/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	GameTime
**
** DESCRIPTION:	Game time
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef GAMETIME_H
#define GAMETIME_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "GameTimer.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int GameTime_c_iMaxTimers = 8;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CGameTime
{
private:

	//class data
	CGameTimer *	m_pGameTimer[GameTime_c_iMaxTimers];
	static int		sm_iNumTimers;

	int				m_iCurrentSpeed;
	int				m_iPreviousSpeed;

	unsigned int	m_uiLastChangeTime;
	unsigned int	m_uiSecondsAtLastChange;

public:

	//class structures
	struct SSaveState
	{
		int				m_iCurrentSpeed;
		int				m_iPreviousSpeed;

		unsigned int	m_uiLastChangeTime;
		unsigned int	m_uiSecondsAtLastChange;
	};

	//class methods
	//setup
	public:		CGameTime(void);
	public:		void Reset();
	public:		const bool LoadState(const SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState) const;

	// process
	public:		void RegisterTimer(CGameTimer *pGameTimer);

	// access
	public:		void SetSpeed(int iNewSpeed);
	public:		const float SpeedMultiplier() const;
	public:		const unsigned int Seconds() const;
	public:		const unsigned int GetSecondsSincePause();
	public:		const bool IsPaused() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CGameTime		GameTime;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/